function	[h,x] = vb_merge_histgram(h1,x1,h2,x2)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%h(n) = num of data in x(n) +- dx/2, dx =  x(2)-x(1)
N1 = length(x1);
N2 = length(x2);
d1 = x1(2) - x1(1);
d2 = x2(2) - x2(1);

h = h1;
x = x1;

for n=1:N1
	xmax = (x1(n) + d1/2);
	xmin = (x1(n) - d1/2);
	ix = find( x2 >= xmin & x2 < xmax);
	if ~isempty(ix)
		for j=1:length(ix)
			m  = ix(j); 
			xx = x2(m); % mid point of h2(m)
			% upper % lower bound of h2(m) in [xmin xmax] for x1(n)
			xup  = min(xx + d2/2 , xmax);
			xlow = max(xx - d2/2 , xmin);
			% add number of h2(m) which included in [xmin xmax]
			h(n) = h(n) + h2(m) * (xup - xlow)/d2;
		end
	end
end
