function	[ymax, ymed] = vb_get_max_med_ratio(data)
% Estimate mean amplitude by using histgram for outlier exclusion
% and calculate amplitude/mean ratio to find bad channel & trials
% amplitude/mean ratio using Median can be also calculated
%   [ymax, med] = vb_get_max_med_ratio(X)
% X(t,n)  : signal at time t & n-th trial         [Tsampla x Ntrial]
% ymax(n) : amplitude/median ratio for each trial [1 x Ntrial]
%         = max_t (abs(X(t,n))) 
% med(n)  : median of abs(X(:,n))
% 
% 2008-6-1 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

yamp = abs(data);
ymax = max(yamp,[],1); % [1 x Ntry]
ymed = median(yamp,1); 

return
