function	[ix_ch,flg] = vb_find_bad_channel(ratio1,ratio2,thred_val,prob_val)
% find bad channel with large max_ratio for number of trials
%  [ix_ch] = vb_find_bad_channel(ratio1,ratio2, thred_val, prob_val)
% ratio1,ratio2 : max ratio : large value indicates bad channel/trials
% thred_val : threshold value
% prob_val  : probability for bad trials to select bad channel
% ix_ch : list of bad channel
% 
% 2008-6-1 Masa-aki Sato
% 2009-1-9 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%if length(thred_val)==1, thred_val = [thred_val, 150, 5]; end;
%if length(thred_val)==2, thred_val = [thred_val, 5]; end;

switch	length(thred_val)
case	1
	% bad channel/trial with large max_ratio
	flg = (ratio1 > thred_val(1)) ...
	    | (ratio2 > thred_val(1)) ;
case	2
	% bad channel/trial with large max_ratio
	flg = (ratio1 > thred_val(1)) ...
	    | (ratio2 > thred_val(2)) ;
case	3
	% bad channel/trial with large max_ratio
	flg = (ratio1 > thred_val(1)) ...
	    | (ratio2 > thred_val(2)) ...
	    | (ratio1 < thred_val(3));
end

% bad channel with large max_ratio for number of trials
ix_ch = find( sum(flg, 2) > prob_val*size(flg,2));

return
%%% END %%%
