function [dir] = vb_saveman_get_dir(saveman)
% return data directry from <<struct>> saveman
% [usage]
%   [dir] = saveman_get_data_dir(saveman)
% [input]
%   saveman : <required> <<struct>> specification for saving files
% [output]
%       dir : value of .data_dir field
% [note]
%
% [history]
%   2007-05-17 (Sako) initial version
%   2007-08-22 (Sako) added aim argument
%   2011-02-17 (Sako) got rid of 2nd argument 'aim'
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('saveman', 'var'), saveman = []; end
[saveman] = inner_check_arguments(saveman);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
dir = saveman.data_dir;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [saveman] = inner_check_arguments(saveman)

func_ = mfilename;

if isempty(saveman)
  error('(%s)saveman is a required parameter', func_);
end

% --- check field
if ~isfield(saveman, 'data_dir')
  % set empty data
  saveman.data_dir = [];
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
