function [transmat, type_bef, type_aft] = vb_posfile_get_transinfo(posfile)
% <<loader>> return transform matrix and coordinate types from POS-MAT file
% [usage]
%   [transmat, type_bef, type_aft] = vb_posfile_get_transinfo(posfile)
% [input]
%    posfile : <required> <<file>> POS-MAT file
% [output]
%   transmat : transform matrix [4x4 double]
%   type_bef : coordinate type before transforming [x1 string]
%   type_aft : coordinate type after transforming [x1 string]
% [note]
%   now on specify
% [history]
%   2008-02-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('posfile', 'var'), posfile = ''; end
[posfile] = inner_check_arguments(posfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
load(posfile, 'trans_info');
if ~exist('trans_info', 'var')
  transmat = [];
  type_bef = '';
  type_aft = '';
  return;
end

transmat = trans_info.trans_mri;
type_bef = trans_info.coord_type_before;
type_aft = trans_info.coord_type_after;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [posfile] = inner_check_arguments(posfile)
func_ = mfilename;
if isempty(posfile)
  error('(%s)posfile is a required parameter', func_);
end
if exist(posfile, 'file') ~= 2
  error('(%s)cannot find posfile : %s', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
