function [center, radius, c_type] = vb_posfile_get_sphericalinfo(posfile)
% <<getter>> return center and radius from POS-MAT file
% [usage]
%   [center, radius, c_type] = vb_posfile_get_sphericalinfo(posfile)
% [input]
%    posfile : <required> <<file>> POS-MAT file
% [output]
%     center : center coordinate of spherical head [1x3 double]
%     radius : radius of spherical head [x1 double]
%     c_type : coordinate type [x1 string]
% [note]
%   
% [history]
%   2008-02-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('posfile', 'var'), posfile = []; end
[posfile] = inner_check_arguments(posfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
center = [];
radius = [];
c_type = [];

pos = load(posfile);
if ~isfield(pos, 'spherical_info')
  return;
end
center = pos.spherical_info.Vcenter;
radius = pos.spherical_info.Vradius;
c_type = pos.spherical_info.coord_type;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [posfile] = inner_check_arguments(posfile)
func_ = mfilename;
if isempty(posfile)
  error('(%s)posfile is a required parameter', func_);
end
if exist(posfile, 'file') ~= 2
  error('(%s)cannot find posfile : %s', func_, posfile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
