function [posinfo] = vb_posfile_get_posinfo(posfile)
% <<getter>> return data from POS-MAT file
% [usage]
%   [posinfo] = vb_posfile_get_posinfo(posfile)
% [input]
%   posfile : <required> <<file>> POS-MAT file
% [output]
%   posinfo : <<struct>> this struct is provided for only here
%           : SensorPosition : [Nch x3 double] coodinates of sensor
%           : CoordType      : [x1 string] coodinate type
%           : ChannelLabel   : {Nch x1 cell} list of sensor name
%           : Vcenter        : [1x3 double] center coordinate of spherical head
%           : Vradius        : [x1 double] radius of spherical head
% [note]
%
% [history]
%   2008-02-26 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('posfile', 'var'), posfile = ''; end
[pos] = inner_check_arguments(posfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

% ----- coordinate and its type
posinfo.SensorPosition = pos.pos;
posinfo.CoordType      = pos.coord_type;
  
% ----- eeg_sensor.name is [n_channel x 1];
posinfo.ChannelLabel   = vb_util_arrange_list(pos.name);

% ----- spherical head data
posinfo.Vcenter        = pos.spherical_info.Vcenter;
posinfo.Vradius        = pos.spherical_info.Vradius;
return;
%
% --- end of inner_get_info_digit_file()
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [pos] = inner_check_arguments(posfile)
func_ = mfilename;

if isempty(posfile)
  error('(%s)posfile is a required parameter', func_);
end

if exist(posfile, 'file') ~= 2
  error('(%s)cannot find posfile:%s', func_, posfile);
end
pos = load(posfile);

% ----- check necessary fields
if ~isfield(pos, 'coord_type')
  error('(%s)invalid pos_file:%s - cannot find coord_type field', ...
    func_, posfile);
end;

if ~isfield(pos, 'pos')
  error('(%s)invalid pos_file:%s - cannot find pos field', ...
    func_, posfile);
end

if ~isfield(pos, 'name')
  error('(%s)invalid pos_file:%s - cannot find name field', ...
    func_, posfile);
end

if ~isfield(pos, 'spherical_info')
  warning('(%s)invalid pos_file:%s - cannot find spherical_info field\n', ...
    func_, posfile);
  pos.spherical_info.Vcenter = [0 0 0];
  pos.spherical_info.Vradius = 0.08;
end
return;
%
% --- end of inner_check_arguments()

% --- END OF FILE --- %
