function [mri_key] = vb_facefile_get_mri_key(face_file)
% get mri_key(MD5) from FACE-MAT file.
% [USAGE]
%    [mri_key] = vb_facefile_get_mri_key(<face_file>);
% [IN]
%    face_file : FACE-MAT file.
% [OUT]
%    mri_key : mri key(MD5 hash key made from analyze.img) [string]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('face_file', 'var') || exist(face_file, 'file') ~= 2
    error('face_file is a required parameter.');
end

%
% --- Main Procedure
%
s = load(face_file);

if ~isfield(s, 'header')
    version = 0;
else
    version = s.header.version;
end

switch(version)
    case 0
        if isfield(s.subject, 'md5_key')
            mri_key = s.subject.md5_key;
        else
            mri_key = [];
        end
    otherwise
        mri_key = s.mri_key;
end
