function [varargout] = vb_version(varargin)
% This function is to know vbmeg version information.
% Usage: [major, minor, alpha_beta, revision] = vb_version;
%        [comparative_result] = vb_version(comparative_operator, ver_str);
%        [comparative_result] = vb_version(ver_str);
%
% --- Format1
% [major, minor, alpha_beta, revision] = vb_version;
%
% example:
%     vbmeg version : 0.5-0.a.0
%      major= 0.5, minor = 0, alpha_beta = 'a', revision = 0
%
% --- Format2
% [comparative_result] = vb_version(comparative_operator, ver_str);
%
% [IN]
%   comparative_operator : '==' or '~=' or '<' or '<=' or '>' or '>='
%   ver_str              : version string formatted as below.
%                          'major-minor.alpha_veta.revision'
%                          ex.'0.5-0.a.0'
% [OUT]
%   comparative_result : true or false.
%
% EXAMPLES
%   If the VBMEG version is '0.5-1.a.0', and the user supplied version is '0.5':
%   result = vb_version('==', '0.5');
%   return result == true  : major numbers are same.
%
%   If the VBMEG version is '0.5-9.a.0', and the user supplied version is '0.5-8':
%   result = vb_version('>', '0.5-8');
%   return result == true
%
%   If the VBMEG version is '0.4-3.a.0', and the user supplied version is '0.4-2.b.1':
%   result = vb_version('<', '0.4-2.b.1');
%   return result == false
%
% --- Format3
%  [comparative_result] = vb_version(ver_str);
%
% [IN]
%   ver_str              : version string formatted as below.
%                          'major-minor.alpha_veta.revision'
%                          ex.'0.5-0.a.0'
% [OUT]
%   comparative_result : true or false.
%
%   This is the same with result = vb_version('==', ver_str);
%
% [history]
% 2010-12-07 taku-y
%  [internal change] vb_version_cmp is used.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

switch(nargin)
    case 0 % [major, minor, revision] = vb_version;
        [ret] = inner_get_version;
        varargout{1} = ret{1};
        varargout{2} = ret{2};
        varargout{3} = ret{3};
        varargout{4} = ret{4};
    case 1 % [comparative_result] = vb_version('0.5-0.a.0');
        input_str = varargin{1};
        if ~ischar(input_str)
            error('version string should be string.');
        end
        %[result] = compare_version('==', input_str);
        [result] = vb_version_cmp(inner_get_version(true), '==', ...
                                  input_str);
        varargout{1} = result;
    case 2 % [comparative_result] = vb_version('==', '0.5-0.a.0');
        comparative_operator = varargin{1};
        input_str = varargin{2};
        if ~ischar(input_str)
            error('version string should be string.');
        end
        %[result] = compare_version(comparative_operator, input_str);
        [result] = vb_version_cmp(inner_get_version(true), ...
                                  comparative_operator, input_str);
        varargout{1} = result;
end


%%%%%%%%%%%%%%%%%%%
% inner functions
%
function [ret] = inner_get_version(isstr)

if nargin==0, isstr = false; end

ret = cell(4,1);
ret{1} = 3.0;      % major version
ret{2} = 0;        % minor version
ret{3} = 'a';      % alpha beta information
ret{4} = 2;        % revision

if isstr
  ret = sprintf('%.1f-%d.%c.%d', ret{1}, ret{2}, ret{3}, ret{4});
end

return;
