function vb_util_make_external_data_file(fpath, fname, f_ext, prec, data, mode)
% make external data file
% [usage]
%   vb_util_make_external_data_file(fpath, fname, f_ext, prec, data, mode)
% [input]
%   fpath : <required> file path
%   fname : <required> file name
%   f_ext : <required> file extension
%   prec  : <required> precision
%   data  : <required> data [N x 1]
%   mode  : <optional> writing mode 'wb') newly write, 'ab') append
% [output]
%   none
% [note]
%
% [history]
%   2010-06-30 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('fpath', 'var'), fpath = ''; end
if ~exist('fname', 'var'), fname = ''; end
if ~exist('f_ext', 'var'), f_ext = ''; end
if ~exist('prec',  'var'), prec  = ''; end
if ~exist('data',  'var'), data  = []; end
if ~exist('mode',  'var'), mode  = ''; end

[fpath, fname, f_ext, prec, data, mode] = ...
  inner_check_arguments(fpath, fname, f_ext, prec, data, mode);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

if exist(fpath, 'dir') ~= 7
  mkdir(fpath);
end

ch_file = sprintf('%s/%s.%s', fpath, fname, f_ext);
% fid = fopen(ch_file, 'wb');
fid = fopen(ch_file, mode);
if fid == -1
  error('(%s)cannot open file (%s)', func_, ch_file);
end

fwrite(fid, data(:), prec);
fclose(fid);
return;

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [fpath, fname, f_ext, prec, data, mode] = ...
  inner_check_arguments(fpath, fname, f_ext, prec, data, mode)
func_ = mfilename;

if isempty(fpath)
  error('(%s) fpath is a required parameter', func_);
end

if ~ischar(fpath)
  error('(%s) fpath must be charactor', func_);
end

if isempty(fname)
  error('(%s) fname is a required parameter', func_);
end

if ~ischar(fname)
  error('(%s) fname must be charactor', func_);
end

if isempty(f_ext)
  error('(%s) f_ext is a required parameter', func_);
end

if ~ischar(f_ext)
  error('(%s) f_ext must be charactor', func_);
end

if isempty(prec)
  error('(%s) prec is a required parameter', func_);
end

if ~ischar(prec)
  error('(%s) prec must be charactor', func_);
end

if isempty(data)
  error('(%s) data is a required parameter', func_);
end

if isempty(mode)
  mode = 'wb';
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
