function [idx1, idx2] = vb_util_get_index(list1, list2)
% return index lists which are the same in two lists
% [usage]
%   [idx1, idx2] = vb_util_get_index(list1, list2)
% [input]
%   list1 : <required> 1st list e.g. [1 3 10 11]
%         :  [N_list1 x 1] or [1 x N_list1]
%   list2 : <required> 2nd list e.g. [1 2 3 ....]
%         :  [N_list2 x 1] or [1 x N_list2]
% [output]
%    idx1 : the same values index list in list1
%         :  [N_samelist x 1]
%    idx2 : the same values index list in list2
%         :  [N_samelist x 1]
% [note]
%   (prior condition)
%     it is not necessary for either of two lists to include another one
%     if they are string lists, they must be cell arrays.
% [history]
%   2008-02-19 (Sako) initial version
%   2010-01-22 (Sako) modified to return empty when whichever list1 or list2
%                     is empty
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('list1', 'var'), list1 = []; end
if ~exist('list2', 'var'), list2 = []; end
[list1, list2, data_type] = inner_check_arguments(list1, list2);
if isempty(list1) || isempty(list2)
  idx1 = [];
  idx2 = [];
  return;
end

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
idx1 = [];
idx2 = [];

switch data_type
  case  0 % string
    for i = 1:size(list1,1)
      tmp_idx = find(strcmp(list2, list1{i}) == 1);
      if ~isempty(tmp_idx)
        idx2 = [idx2; tmp_idx];
        idx1 = [idx1; i];
      end
    end
    
  case  1 % numerical
    for i = 1:size(list1,1)
      tmp_idx = find(list2 == list1(i));
      if ~isempty(tmp_idx)
        idx2 = [idx2; tmp_idx];
        idx1 = [idx1; i];
      end
    end
end

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [list1, list2, data_type] = inner_check_arguments(list1, list2)
func_ = mfilename;
data_type = [];

if isempty(list1)
%   error('(%s)list1 is a required parameter', func_);
  return;
end

if isempty(list2)
%   error('(%s)list2 is a required parameter', func_);
  return;
end

% 1) numeric,  0) string
if isnumeric(list1)
  data_type = 1;
else
  data_type = 0;
end

% arrange to [N x 1]
list1 = vb_util_arrange_list(list1);
list2 = vb_util_arrange_list(list2);
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
