function [idx_list] = vb_util_get_cross_checked_list(src_list, dst_list)
% do cross check source label list with destination label list
% [usage]
%   [idx_list] = vb_util_get_cross_checked_list(src_list, dst_list)
% [input]
%   src_list : <required> source list of label
%            :  [N x 1] or [1 x N]
%   dst_list : <required> destination list of label
%            :  [M x 1] or [1 x M]
% [output]
%   idx_list : index list [N x 2]
%            :  [dst_idx, src_idx] (if N/A, src_idx is set '-1')
% [note]
%
% [history]
%   2007-04-13 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('src_list', 'var') src_list = []; end;
if ~exist('dst_list', 'var') dst_list = []; end;
[src_list, dst_list] = inner_check_arguments(src_list, dst_list);
% both lists are arranged [1 x N]

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
N_DATA = size(src_list, 2); % [1 x N]
idx_list = zeros(N_DATA, 2);

for i_data = 1:N_DATA
  idx_list(i_data, 1) = i_data;
  idx_list(i_data, 2) = inner_search_label(dst_list, src_list{i_data});
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [src_list, dst_list] = inner_check_arguments(src_list, dst_list)
if isempty(src_list)
  error('src_list is a required parameter');
end

if isempty(dst_list)
  error('dst_list is a required parameter');
end

src_list = vb_util_arrange_list(src_list,1);
dst_list = vb_util_arrange_list(dst_list,1);
return;
%
% --- end of inner_check_arguments()

% --- inner_search_label()
%
function [app_idx] = inner_search_label(label_list, label)
% <<prior conditions>>
%  Both label_list and label are not empty.
%  label_list is [1 x N]

N_A = -1;   % not applicable
list_len = size(label_list, 2); % [1 x N]

for i_d = 1:list_len
  if strcmp(label_list{i_d}, label)
    app_idx = i_d;
    return;
  end
end

app_idx = N_A;
return;
%
% --- end of inner_search_label()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
