function [mask_list, mask_idx, omit_list, omit_idx] = vb_util_clean_list(body, idx)
% return list exclusive of idx from body
% [usage]
%   [mask_list, mask_idx, omit_list, omit_idx] = vb_util_clean_list(body, idx)
% [input]
%   body : <required> baseline list [N x1] or [1x N]
%    idx : <required> index you want to clean from body [N x1] or [1x N]
% [output]
%   mask_list : list in which the 'idx' elements are cleaned [Nx1]
%   mask_idx  : indices of body which are except for idx
%   omit_list : list to be omitted
%   omit_idx  : index list to be omitted
% [note]
%
% [history]
%   2008-02-27 (Sako) initial version
%   2009-08-10 (Sako) added return values (omit_list and omit_idx)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('body', 'var'), body = []; end
if ~exist('idx', 'var'), idx = []; end
[body, idx] = inner_check_arguments(body, idx);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
body_len = length(body);

% ----- get mask list
mask_idx = [];
omit_idx = [];

for i_body = 1:body_len
  if ~any(i_body == idx)
    mask_idx = [mask_idx; i_body];
  else
    omit_idx = [omit_idx; i_body];
  end
end
mask_list = body(mask_idx);
omit_list = body(omit_idx);
return
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [body, idx] = inner_check_arguments(body, idx)
func_ = mfilename;
if isempty(body)
  error('(%s)body is a required parameter', func_);
end

if isempty(idx)
  error('(%s)idx is a required parameter', func_);
end

if length(body) < length(idx)
  error('(%s)body(L=%d) and idx(L=%d) are wrong', ...
    func_, length(body), length(idx));
end

% ----- arrange to [N x1]
body = vb_util_arrange_list(body);
idx = vb_util_arrange_list(idx);
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
