function arranged_list = vb_util_arrange_list(list, mode)
% arrange to [N x 1] or [1 x N]
% [usage]
%   arranged_list = vb_util_arrange_list(list, mode)
% [input]
%   list : array whose size must be [N x 1] or [1 x N]
%   mode : arranging mode (0 or 1) [0]
%        :   0 : arrange to [N x 1]
%        :   1 : arrange to [1 x N]
% [output]
%   arranged_list : list which has been arranged
% [note]
% 
% [history]
%   2006-12-05 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
if ~exist('mode', 'var') || isempty(mode)
  mode = 0;
end

nr = size(list,1);
nc = size(list,2);

if nr ~= 1 && nc ~= 1
  error('invalid list size [%d x %d]', nr, nc);
end

if mode == 0  % to [N x 1]
  if nr == 1
    arranged_list = list';
  else
    arranged_list = list;
  end
elseif mode == 1  % to [1 x N]
  if nr == 1
    arranged_list = list;
  else
    arranged_list = list';
  end
else
  error('undefined mode : %d', mode);
end

%%% END OF FILE %%%
