function [MEGinfo,bexp,eeg] = vb_trial_rejection(MEGinfo,bexp,eeg,rejectTrial)
%function [MEGinfo,bexp,eeg] = vb_trial_rejection(MEGinfo,bexp,eeg,rejectTrial)
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Absolute channel inndex for bexp, pick & Qpick
TrialNumber = MEGinfo.TrialNumber;
Ntrial = length(TrialNumber);

% Extract active channel index from 'MEGch_id' different from 'reject_channel'
Trial_act = vb_setdiff2(TrialNumber, rejectTrial);

MEGinfo.Nrepeat = length(Trial_act);
MEGinfo.TrialNumber = Trial_act;

Nmax   = max(TrialNumber);

if max(rejectTrial) > Nmax,
	error('Reject trial index is larger than trial number');
end

if Ntrial ~= (MEGinfo.Nrepeat + length(rejectTrial))
	error('Reject trial index is not in trial index');
end

% Convert absolute index to relative index
itrans = zeros(Nmax,1);
itrans(TrialNumber) = 1:Ntrial;

id_act = itrans(Trial_act);     % active trial index

% Extract active channel
bexp  = bexp(:,:,id_act);
eeg  = eeg(:,:,id_act);

return
