function varargout = vb_struct2vars(argS, fieldname);
% 
% example,
% 1. [basisfile,brainfile] = vb_struct2vars(bayes_parm,{'basisfile','brainfile'});
% 2. vb_struct2vars(bayes_parm,{'basisfile','brainfile'}); 
% In the second case, the variables are created in the workspace where
% a 'caller' function is located.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~isstruct(argS)|length(argS)~=1
      error('Single Input Must be a Scalar Structure.')
end

Nfield = length(fieldname);

S.type = '.';
for i = 1 : Nfield
    if ~isfield(argS, fieldname{i})
        eval(['subargS.' fieldname{i}, '=[];']);
    else
        eval(['subargS.' fieldname{i}, '=argS.', fieldname{i} ';']);
    end
    if nargout==0 % assign in caller
         S.subs=fieldname{i}; % for speed, inline getfield operation
         assignin('caller',fieldname{i},subsref(subargS,S))
    else          % dump into variables
        S.subs=fieldname{i}; % for speed, inline getfield operation
        varargout{i}=subsref(subargS,S);
    end
end
   
    
   
