function vb_savefig_as_shown(fig, filename, formattype)
% Save figure as it is shown
%
% - Input
%   fig : Figure number
%   filename : File name
%   formattype : File format (default : '-dpng')
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3
    formattype = '-dpng';
end

% Make directory to save figure if it does not exist
[PATH, NAME, EXT] = vb_get_file_parts(filename);
if ~isempty(PATH) && ~exist(PATH, 'dir')
    vb_mkdir(PATH);
    vb_disp(['Create directory: ' PATH]);
end

set(fig, 'InvertHardCopy', 'off');
set(fig, 'PaperPositionMode', 'auto')

print(fig, filename, formattype, '-r0')