function [removed] = vb_rm_trailing_slash(string)
% This function removes trailing slash(or backslash) character.
% [USAGE]
%    [removed] = vb_rm_trailing_slash(string);
% [IN]
%     string : character string
% [OUT]
%    removed : character string after removing trailing slash character.
%
% [HISTORY]
%   2010-07-01 rhayashi initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('string', 'var')
    error('string is a required parameter.');
end
if isempty(string)
    removed = string;
    return;
end
if ~ischar(string)
    error('string must be a character string');
end

%
% --- Main Procedure
%
removed = string;

while(1)
    if isempty(removed), break; end

    last = removed(end);
    switch(last)
        case {'\', '/', '\'}
            removed = removed(1:end-1);
        otherwise
            break;
    end
end
