function [new_F, new_V] = vb_reducepatch(F, V, R)
% reduce patch function
% This is created to switch reduce patch algorithm by VBMEG.
% Please change global value 'reduce_algorithm' in vbmeg.m if you want to
% switch it and re-run vbmeg.m
% [Usage]
%    [new_F, new_V] = vb_reducepatch(F, V, R);
%    [NFV]          = vb_reducepatch(F, V, R);
% 
global reduce_algorithm;

if strcmpi(reduce_algorithm, 'CGAL')

	[a, tmp_name] = vb_get_file_parts(tempname);
	evalin('base', ['ISO2MESH_SESSION=''' tmp_name ''';']);

	if R < 1
	    [new_V, new_F] = meshresample(V, F, R);
	else
	    ratio =  R/size(F,1);
	    [new_V, new_F] = meshresample(V, F, ratio);
	end

	evalin('base', 'clear ISO2MESH_SESSION');
else
        % MATLAB reducepatch
        [new_F, new_V] = reducepatch(F, V, R);
end

if nargout == 1
    NFV = struct;
    NFV.faces = new_F;
    NFV.vertices = new_V;
    new_F = NFV;
    new_V = [];
end
