function [abs_path] = vb_realpath(input_path)
% vb_realpath returns absolute path.
% [USAGE]
%    [abs_path, err] = vb_realpath(input_path);
% [IN]
%    input_path : relative path or absolute path or 
%                 relative file name or absolute file name
% [OUT]
%    abs_path : absolute path
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('input_path', 'var'), input_path = ''; end

%
% --- Main Procedure
%
javaFileObj = java.io.File(input_path);

if (javaFileObj.isAbsolute() == false)
    abs_path = fullfile(pwd, input_path);
else
    abs_path = input_path;
end
