function	[fid, result, next_line] = vb_read_to_keyword(fid,key,skip)
% Search keyword in text file 
%  [fid, result, next_line] = vb_read_to_keyword(fid,key)
%  [fid, result, next_line] = vb_read_to_keyword(fid,key,skip)
% --- Input
% fid  : file handle 
% key  : skip to the line with this key word
% skip : if this skip string is at the begging of the line, skip lines
% --- Output
% fid   : file pointer is at the next line of keyword line
%         if skip is given, lines with skip string at the begging of the line
%         are skiped
% next_line : line text including key
% if result is empty, key is not find
% if result > 0, result is position index of key in next_line
%
% Masa-aki Sato 2008-07-25
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% K = STRFIND(TEXT,PATTERN) ϡʸ TEXT ǡʸ PATTERN и
%  ǽΥǥåϤޤ

result = [];
if nargin < 3, skip = []; end;

% find line with keyword
if ~isempty(key),
	while 1
	    next_line = fgetl(fid);
	    if ~ischar(next_line), result = []; break, end;
	    
	    result = strfind(next_line,key);
		if ~isempty(result), break, end;
	end
else
    next_line = fgetl(fid);
end

if nargin < 3, return; end

% skip line with comment keyword
if ~isempty(skip),
	while 1
	    if ~ischar(next_line), break, end;
	    
	    result_s = strfind(next_line,skip);
		if isempty(result_s) || result_s > 1, break, end;
		
	    next_line = fgetl(fid);
	end
	
end
