function [Y,A,Base] = vb_polysincosfilt(X,basis,sampHz,flag_const)
% A kind of high pass filter
%
%[Y,A,Base] = vb_polysincosfilt(X,basis,sampHz,flag_const)
%
%Y : drift free data
%
%X : Ntrial(Nsensor) * Nsamp
%basis : sine wave cycle  e.g. [4 8 16]
%sampHz:  e.g. 1000
%flag_const: 1 - add constant term in basis matrix.
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<4
  flag_const = 1;
end

isi = 1/sampHz;

[Nsensor,Nsamp] = size(X);
t = isi:isi:isi*Nsamp;

Nbase = length(basis);

for i = 1:Nbase
    Base(i,:) = sin(2*pi*t*(1/basis(i)));
    Base(Nbase+i,:) = cos(2*pi*t*(1/basis(i)));
end
if flag_const
  Base(Nbase*2+1,:) = 1;
end

%model : X = A*Base
A = X*Base'*pinv(Base*Base');
Drift = A*Base;
Y = X - Drift;
