function [answer_b] = vb_include_valiable(check_file, value_name)
%
% This function checks the specified file whether includes
% the value or not.
% Warn: cannot detect 'value_name' and 'check_file', 'answer_b'.
%
% [IN] check_file : full_path
%      value_name : character string
%
% answer : true or false
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

answer_b = false;
if ~exist(check_file, 'file')
    return;
end

load(check_file);

value_names = whos;
result = strmatch(value_name, {value_names.name});

if result
    answer_b = true;
else
    answer_b = false;
end
