function	[err , Sx, Sy, indx ] = vb_err_cell(x,y)
% calculate difference of two cell arrays
% err = vb_err_array(x,y) 
%     = sum( abs(x-y) )/sum( abs(x) )
%     = sum( abs(x-y) ) if sum( abs(x) ) == 0
% --- Input
% x, y : numerical cell array
% --- Output
% err : normalized error
% --- Error info
% [err , Sx, Sy, indx ] = vb_err_cell(x,y)
%
% if size of cell array x & y is different, 
%   err = -1 is returned, and error massage is printed
%   Sx, Sy = size of x & y
%   indx = []
% if size of each element in the cell is different, 
%   err = -2 is returned, and error massage is printed
%   indx   = element index with different 
%   Sx, Sy = size of elements x{indx} & y{indx}
%
% 2006/10/3 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[N1, M1] = size(x);
[N2, M2] = size(y);

Sx   = [N1, M1];
Sy   = [N2, M2];
indx = [];

if N1~=N2 | M1~=M2
	print_size_dif(Sx,Sy);
	err  = -1;
	return
end

xx  = 0;
err = 0;

for n=1:N1
	for m=1:M1
		Sx = size(x{n,m});
		Sy = size(y{n,m});
		if sum(abs(Sx - Sy)) > 0,
			print_insize_dif(Sx,Sy,n,m);
			err  = -2;
			indx = [n,m];
			return
		end
		xx  = xx  + sum(sum(sum(abs(x{n,m}))));
		err = err + sum(sum(sum(abs(x{n,m} - y{n,m}))));
	end
end

if xx > 0,
	err = err/xx;
end

function print_size_dif(Sx,Sy)

fprintf('Size of two cell arrays are different\n')
fprintf('Size = ')
disp(Sx)
fprintf('Size = ')
disp(Sy)

function print_insize_dif(Sx,Sy,n,m)

fprintf('Size of cell element {%d,%d} is different\n', n,m)
fprintf('Size = ')
disp(Sx)
fprintf('Size = ')
disp(Sy)



% if x and y is vector, only check length
%if N1==1 
%	x = x';
%end
%if N2==1 
%	y = y';
%end
%
%[N1, M1] = size(x);
%[N2, M2] = size(y);
