function [parm, cancelled] = vb_edit_struct(parm, caption)
% edit struct field by input dlg.
% [USAGE]
%    [parm, cancelled] = vb_edit_struct(<parm> [,caption]);
% [IN]
%       parm : <<structure>> to be editted parameter.
%    caption : <<char array>> window caption
% [OUT]
%         parm : <<structure>> editted parameter.
%    cancelled : true : If edit operation is cancelled, this flag switched true.
%                false
% [NOTE]
%    ԽǤfieldΥפ, scalar, matrix, char array2
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('parm', 'var')
    error('parm is a required parameter.');
end
if ~exist('caption', 'var')
    caption = 'Parameter';
end

%
% --- Main Procedure
%
cancelled = false;
parm_names = fieldnames(parm);
Nfield = length(parm_names);
% inputdlgλͤparm_names, parm_valueϥ(Ȥʸ)Ǥɬפ
parm_value = cell(Nfield, 1);
numeric_flag = zeros(Nfield, 1); % ͤϰöʸѴȤǿ᤹ͤ
col_size = zeros(Nfield, 1);     % matrixξ硢inputdlgιԿ䤹

for k=1:Nfield
    tmp = parm.(parm_names{k});
    [col_size(k), n] = size(tmp);
    if col_size(k) <= 0, col_size(k) = 1; end
    if isnumeric(tmp)
        tmp = num2str(tmp);
        numeric_flag(k) = true;
    end
    parm_value{k} = tmp;
end

% display dialog
input = inputdlg(parm_names, caption, col_size, parm_value, 'on');

% check cancell or not
if isempty(input)
    cancelled = true;
else
    % parm¤κƹ
    for k=1:Nfield
        if numeric_flag(k)
            parm.(parm_names{k}) = str2num(input{k});
        else
            parm.(parm_names{k}) = input{k};
        end
    end
end
