function [parm] = vb_load_brain_proj(parm)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% 2005-03-20 Modified by TY
%global	define
global vbmeg_inst; 
define = vbmeg_inst.const; 

% project file򳫤
if ~isempty( findstr(parm.file.brain, define.BRAIN_EXTENSION) )
  BRAINfile =...
      parm.file.brain(1:findstr(parm.file.brain, define.BRAIN_EXTENSION)-1);
else
  BRAINfile = parm.file.brain;
end
project_fname = [parm.dir.brain  BRAINfile define.BRAIN_PROJECT_EXTENSION];
fd = fopen(project_fname, 'r');


CR = sprintf('\n');	% ԥ

while true
  str = fgets(fd);
    
  if str == -1
    break;		% End of FILE
  elseif strcmp(str, CR) | str(1)=='#'
    ;			% '#'ǻϤޤԤCOMMENT line
  else
    % ǡե̾ȥǥ쥯ȥ̾ɤࡣ
    mri_dir = sscanf(str,'dir.mri = %s');
    dicom_file = sscanf(str,'file.dicom = %s');
    right_dir = sscanf(str,'dir.bvoy_right = %s');
    right_file = sscanf(str, 'file.right = %s');
    left_dir = sscanf(str, 'dir.bvoy_left = %s');
    left_file = sscanf(str, 'file.left = %s');
    inf_right_dir = sscanf(str,'dir.inf_right = %s');
    inf_right_file = sscanf(str, 'file.inf_right = %s');
    inf_left_dir = sscanf(str, 'dir.inf_left = %s');
    inf_left_file = sscanf(str, 'file.inf_left = %s');
    brain_dir = sscanf(str, 'dir.brain = %s');
    brain_file = sscanf(str, 'file.brain = %s');
    inflate_dir = sscanf(str, 'dir.inflate = %s');
    inflate_file = sscanf(str, 'file.inflate = %s');
    area_dir = sscanf(str,'dir.area = %s');
    area_file = sscanf(str, 'file.area = %s');
    fmri_dir = sscanf(str,'dir.act = %s');
    fmri_file = sscanf(str, 'file.act = %s');

    % keywordcommentԤɤࡣ
    brain_keyword = strncmp(str, 'brain_parm.brain_keyword =', ...
	length('brain_parm.brain_keyword ='));
    brain_comment = strncmp(str, 'brain_parm.brain_comment =', ...
	length('brain_parm.brain_comment ='));

    % ѥ᡼ɤࡣ
    Reduce_ratio = sscanf(str, 'brain_parm.Reduce_ratio = %f');
    Rmax = sscanf(str, 'brain_parm.Rmax = %f');
    ignore_offset = sscanf(str, 'brain_parm.ignore_offset = %f');
    Nstep = sscanf(str, 'brain_parm.Nstep = %f');
    Display = sscanf(str, 'brain_parm.Display = %d');

    if ~isempty(mri_dir)	parm.dir.mri = mri_dir;
    elseif ~isempty(dicom_file)	parm.file.dicom = dicom_file;    
    elseif ~isempty(right_dir)	parm.dir.bvoy_right = right_dir;
    elseif ~isempty(right_file)	parm.file.right = right_file;
    elseif ~isempty(left_dir)	parm.dir.bvoy_left = left_dir;
    elseif ~isempty(left_file)	parm.file.left = left_file;
    elseif ~isempty(inf_right_dir)	parm.dir.right_inf = inf_right_dir;
    elseif ~isempty(inf_right_file)	parm.file.right_inf = inf_right_file;
    elseif ~isempty(inf_left_dir)	parm.dir.left_inf = inf_left_dir;
    elseif ~isempty(inf_left_file)	parm.file.left_inf = inf_left_file;
    elseif ~isempty(brain_dir)		parm.dir.brain = brain_dir;
    elseif ~isempty(brain_file)		parm.file.brain = brain_file;
    elseif ~isempty(inflate_dir)	parm.dir.inflate = inflate_dir;
    elseif ~isempty(inflate_file)	parm.file.inflate = inflate_file;
    elseif ~isempty(area_dir)		parm.dir.area = area_dir;
    elseif ~isempty(area_file)		parm.file.area = area_file;
    elseif ~isempty(fmri_dir)		parm.dir.act = fmri_dir;
    elseif ~isempty(fmri_file)		parm.file.act = fmri_file;
    
    elseif brain_keyword
      parm.brain_parm.brain_keyword =...
	  sscanf(str, 'brain_parm.brain_keyword = %s');
    elseif brain_comment
      parm.brain_parm.brain_comment =...
	  sscanf(str, 'brain_parm.brain_comment = %s');
    
    elseif ~isempty(Reduce_ratio)
      parm.brain_parm.Reduce_ratio = Reduce_ratio;
    elseif ~isempty(Rmax)
      parm.brain_parm.Rmax = Rmax;
    elseif ~isempty(ignore_offset)
      parm.brain_parm.ignore_offset = ignore_offset;
    elseif ~isempty(Nstep)
      parm.brain_parm.Nstep = Nstep;
    elseif ~isempty(Display)
      brain_parm.Display = Display;
    else
      error(str);	% ѥ᡼եerrorԤȯ
    end
    
  end	% <-- End of 'if str == -1 ... elseif strcmp(...) ... else'
end	% <-- End of 'while true'

fclose(fd);

