function	[pos, channel_info] = vb_load_channel(megfile, active_swt)
% This function returns channel coordinate value for plot
% [usage]
%   [pos, channel_info] = vb_load_channel(megfile, active_swt)
% [input]
%      megfile : <required> <<file>> MEG/EEG-MAT file
%   active_swt : <optional> <<boolean>> active switch [true]
%              :   true) return only active channels
%              :  false) return all then channels
% [output]
%            pos : 3D-coordinate of channel position [Nchannel x 3]
%   channel_info : <<struct>> channel information of loaded channel.
%                :  .Active [Nchannel x 1]
%                :  .Name   [Nchannel x 1]
%                :  .Type   [Nchannel x 1]
%                :  .ID     [Nchannel x 1]
% [note]
%   does not check parameter
% [history]
%   2007-8-23 Masa-aki Sato
%   2008-04-16 (Sako) added active_swt
%   2011-08-31 (Sako) modified how to call vb_load_sensor
%   2017-11-22 rhayashi
%    return central coordinate value of coils as channel position.
%   2018-08-23 (Takeda) removed ch_indx to make code simple
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('active_swt', 'var')
    active_swt = true;
end

[pick, Qpick, CoilWeight, Vcenter, result, channel_info] = vb_load_sensor(megfile, '', '', active_swt);

%  CoilWeight(m,n) : n-th coil weight for m-th channel [Nchannel x Ncoil]

if isempty(CoilWeight)
    pos = pick;
else
    Nch = size(CoilWeight, 1);
    pos = zeros(Nch,3);
    for n=1:Nch
        pos(n,:) = mean(pick(CoilWeight(n, :) ~= 0, :), 1);
    end
end

% --- END OF FILE --- %
