function [basis,Norient]=vb_load_basis(basisfile,patch_norm,brainfile);
% Load leadfileld matrix.
%
% [syntax]
% [basis,Norient]=vb_load_basis(basisfile)
%
% [input]
% basisfile : <<string>> Leadfield file (.basis.mat)
% patch_norm: <optional> <<bool>> If true, leadfield is multiplied by patch area.
% brainfile : <optional> <<string>> Brain file, necessary if patch_norm is ON.
%
% [output]
% basis  : <<matrix>> Leadfield matrix.
%  basis( Norient * Nvertex , Npick)
% 	  basis( n, k )   : k-th sensor magnetic field for dipole current
% 	  at n-th dipole.
% Norient: <<int>> Number of independent current orientation.
%
% 2010-11-15 Taku Yoshioka
%  Comment modified.
% 2022-04-27 Y. Takeda
%  Added option for patch_norm = ON
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


s = load(basisfile);

% extra dipole basis
if isfield(s, 'extra_basis_parm')
    Norient = 3;
    basis   = s.basis;
    return;
else
% basis
    Norient = s.basis_parm.Basis_mode;

    if exist('patch_norm', 'var') & patch_norm==ON,
        [tmp1,tmp2,tmp3,tmp4,xxA] = vb_load_cortex(brainfile, 'subj');
        S = repmat(xxA, Norient, size(s.basis, 2));
        basis = s.basis.*S;
    else
        basis = s.basis;
    end
end

