function shell_info = vb_load_head_shell_info(head_file)
% Shell information of specified head_file.
% [Usage]
%    shell_info = vb_load_head_shell_info(head_file);
% [Input]
%    head_file  : VBMEG head model file(.head.mat)
% [Output]
%    shell_info : information of the specified head_file.
%          .Nshell  : The number of shells.  (e.g. 3)
%          .tags    : Shell tags.            (e.g. {'CSF', 'Skull', 'Scalp'})
%          .Nvertex : The number of vertices (e.g. [2000, 2000, 2000])
%          .Nface   : The number of patches  (e.g. [4000, 4000, 4000])
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('head_file', 'var')
    error('head_file is a required.');
end
if exist(head_file, 'file') ~= 2
    error('Specified file not found.');
end

%
% --- Main Procedure
%
shell_info = struct;

Nshell = vb_head_get_layer_num(head_file);
tmp_info = cell(0);
for k=1:Nshell
    tmp_info{k} = vb_head_get_specified_headinfo(head_file, k);
end
% There is a case that the 1shell model doesn't have LayerTag.
if Nshell == 1 &&  ~isfield(tmp_info{1}, 'LayerTag')
    tmp_info{1}.LayerTag = {'CSF'};
end

% Create infomation structure
shell_info.Nshell    = Nshell;
shell_info.tags      = cell(1, Nshell);
shell_info.Nvertex   = zeros(1, Nshell);
shell_info.Nface     = zeros(1, Nshell);

for k=1:Nshell
    shell_info.tags{k}    = tmp_info{k}.LayerTag;
    shell_info.Nvertex(k) = size(tmp_info{k}.Vhead, 1);
    shell_info.Nface(k)   = size(tmp_info{k}.Fhead, 1);
end
