function C = vb_load_cortex_pmat(brain_file,key)
% Load coregistration matrix.
%
% [syntax]
% C = vb_load_cortex_pmat(brain_file,key)
%
% [input]
% brain_file: <<string>> Cortical surface model file (.brain.mat).
% key       : <<string>> ID of coregistration matrix.
%
% [output]
% C         : <<matrix>> Coregistration matrix.
%
% 2010-11-18 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(brain_file,'Call');

for i=1:length(Call.key)
  if strcmp(Call.key{i},key), 
    C = Call.C{i};
    return;
  end;
end;

error(['Coregistration matrix ''' key ''' does not exist.']);

return;
