function	[Ndipole, NdipoleL, BV_index, Vinfo] = vb_load_cortex_info(brainfile, coord_type)
% Get cortex points information
%  [Ndipole] = vb_load_cortex_info(brainfile, coord_type)
%  [Ndipole, NdipoleL, BV_index, Vinfo] = vb_load_cortex_info(brainfile)
% -- Input 
% brainfile   : Brain file name
% coord_type  : <<optional>>
%                = 'subj' : personal cortex info is returned.
%                = ''     : [default]
%                         : V1 format: personal cortex info is returned.
%                         : V2 format: standard cortex info is returned.
% --- Output
% Ndipole = vb_load_cortex_info(brainfile)
% [Ndipole, NdipoleL] = vb_load_cortex_info(brainfile)
% [Ndipole, NdipoleL, BV_index, Vinfo] = vb_load_cortex_info(brainfile)
% [Ndipole, NdipoleL, BV_index, Vinfo] = vb_load_cortex_info(brainfile, 'subj')
% 
% Dimension Info
%
% Ndipole   : # of vertex points 'V' in cortex
% NdipoleL  : # of vertex points in left cortex
%
% BV_index.Left  : BrainVoyager vertex index corresponding to left cortex
% BV_index.Right : BrainVoyager vertex index corresponding to right cortex
%
% Appricable for both New & Old version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('coord_type', 'var')
    coord_type = [];
end

if strcmp(coord_type, 'subj')
    warning('off', 'MATLAB:load:variableNotFound');
    load(brainfile, 'subj');
    warning('on',  'MATLAB:load:variableNotFound');
    if exist('subj', 'var')
        Vinfo = subj.Vinfo;
        BV_index = subj.BV_index;
    else
        load(brainfile, 'Vinfo', 'BV_index');
    end
elseif isempty(coord_type)
    load(brainfile, 'Vinfo', 'BV_index');
else
    error('Unknown coord_type was specified.');
end

if exist('Vinfo','var'),
    % Dimension info
    Ndipole  = Vinfo.Ndipole  ;
    NdipoleL = Vinfo.NdipoleL ;
else
    load(brainfile,'V','F');
    
    % Dimension info
    Ndipole   = size(V,1);
    NdipoleL  = F.NdipoleL;

    % BrainVoyager vertex index corresponding to reduced brain 'V'
    load(brainfile,'IndxL','IndxR');
    BV_index.Left  = IndxL; 
    BV_index.Right = IndxR;
end
