function keyset = vb_get_keyset_area(areafile)
% This function is used to get the set of cortical area IDs. 
%
% --- Syntax
% keyset = vb_get_keyset_area(areafile)
%
% --- Input
% areafile: Cortical area file (.area.mat). 
%
% --- Optional input
%
% --- Output
% keyset{i}: Set of IDs of cortical areas. 
%
% --- Example
% >> areafile = './TY/data/TY.area.mat';
% >> key = vb_get_keyset_area(area);
%
% --- History
% 2004-10-09 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if exist(areafile) ~= 2
  error('Area data file is not found.');
  keyset = [];
else
  load(areafile,'Area')
  keyset = cell(length(Area),1);
  for i = 1:length(Area)
    keyset{i} = Area{i}.key;
  end
end
