function	Indx = vb_find_match_point( Vold, Vnew, Nstep, DispChara)
% ---  Find old vertex point corresponding to new vertex
%  Indx = vb_find_match_point( Vold, Vnew, Nstep, DispChara)
%
% Indx      : Old vertex index list corresponding to new vertex
%
% Vold      : Old vertex point
% Vnew      : New vertex point
% Nstep     : Number of steps to divide Z-axis
% DispChara : Display character
%
% Originaly written by S.Kajihara
% Ver 1.0  modified by M. Sato  2003-3-15
% Ver 2.0  modified by M. Sato  2005-4-8
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<4, DispChara = []; end;

% Old model point number
[Npoint, D] = size(Vold);

% New model point number
Ndipole 	= size(Vnew,1);
Indx		= zeros(Ndipole,1);	% Old vertex index list

% Slice definition
Zmax  = max(Vold(:,3));
Zmin  = min(Vold(:,3));
Zwid  = (Zmax - Zmin)/200;
Zmax  = Zmax + Zwid;
Zmin  = Zmin - Zwid;
Zstep = max( (Zmax-Zmin)/Nstep , eps);
Zlist = Zmin:Zstep:Zmax;

% Loop for slices in z-direction
for n=1:Nstep,
	% Find vertex points in this slice
	iold  = find( Vold(:,3) >= Zlist(n) & Vold(:,3) < Zlist(n+1));
	inew  = find( Vnew(:,3) >= Zlist(n) & Vnew(:,3) < Zlist(n+1));
	Nold  = length(iold);
	Nnew  = length(inew);
	Vold2 = Vold(iold,:);

	for i=1:Nnew,
		k	  = inew(i);			% New vertex index
		Vnew2 = Vnew( k,:);
		
		% Distance between new and old vertex
        dd	= (Vold2(:,1) - Vnew2(1)).^2 ...
            + (Vold2(:,2) - Vnew2(2)).^2 ...
            + (Vold2(:,3) - Vnew2(3)).^2;
            
		% Find nearest old vertex
	    [md,ix]  = min(dd); 
	    Indx(k)  = iold(ix);  		% Old vertex index for 'k'
	end;
    
    if ~isempty(DispChara), fprintf('%s',DispChara); end;
end

ixz = find(Indx==0);
if ~isempty(ixz), fprintf('There are unfixed index\n'); end;
%fprintf('--- DEBUG NEW Version\n')
