function [ix_peak] = vb_extract_peak(J,ix_J,ix_area,nextDD,nextIX,Rs,Re)
% extract multiple local peak current
%   [ix_peak] = vb_extract_peak(J,ix_J,ix_area,nextDD,nextIX,Rsearch,Rpeak)
% --- Input
% J(n,t)         : n-th vertex  t ή
% ix_J(n)        : J(n,t) бĺǾǥå
% ix_area{Npeak} : ΰix_area{i}դή٥ԡõ
% Rsearch        : ΰix_area{i}Ⱦ Rsearch [m] ΰǥԡõ
% Rpeak          : ԡȾ Rpeak [m] ix_peak{i}
% nextDD,nextIX  : Ǿǥ˵
%
% --- Output
% ή٤Υԡ Npeak  Ф
%
% ix_peak{i}: ix_area{i}ΥԡȤζ˵ĺǥå (i=1:Npeak)
% ix_peak{i}(1)  ix_area{i} ΥԡǥåȤʤ롣
%
% --- Example
% ix_area = {[1:100], [1:100], [200:300]};
% [nextDD,nextIX] = vb_load_cortex_neighbour(brainfile) 
% [ix_peak] = vb_extract_peak(Jact, ix_act, ix_area, nextDD, nextIX, 0, 0.006)
%
% ǥå [1:100] 顢ԡ2ԡõ
% ǥå [200:300] 顢ԡõ
% ޤ줾ΥԡȾ6mm ζ˵ǥå
% 2ԡõˤϡԡ 6mm Ͻ롣
%
% --- Notes
% * iܤΥԡФݡ
%   ix_peak{j} (j < i) ˴ޤޤĺõϰϤ롣
%
% 2003-03-08 Taku Yoshioka
% 2006-9-18 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Npeak = length(ix_area); % Хԡ

%
% õϰϤη
%
ix_search = cell(Npeak,1);

for i = 1:Npeak
  if isempty(ix_area{i})
    ix_search{i} = '';
  else
    ix_search{i} = [];
    for j = 1:length(ix_area{i})
      ix_tmp = find(nextDD{ix_area{i}(j)}<=Rs);
      ix_search{i} = [ix_search{i}; nextIX{ix_area{i}(j)}(ix_tmp)];
    end
    ix_search{i} = unique(ix_search{i});
  end
end

%
% ήʬۤΥԡ
%
JJ = sum(abs(J),2);
ix_peak = cell(Npeak,1);
n_peak  = 0;

for i = 1:Npeak
  % transform to relative index within 'ix_J'
  [jx , jx_all]= vb_index2indexsub(ix_search{i}, ix_J);
  if isempty(jx), continue; end;
  
  % Find maximum vertex
  [tmp,ix_max] = max(JJ(jx));
  
  % Absolute index for maximum vertex
  ix_max = jx_all(ix_max);
  
  % Neighbor index within Radius 'Re'
  n_peak  = n_peak + 1;
  ix_next = find( nextDD{ix_max} <= Re );
  ix_peak{n_peak} = nextIX{ix_max}(ix_next);
  
  % Eliminate previous peak points
  kx = vb_index2indexsub(ix_peak{n_peak}, ix_J);
  JJ(kx) = 0;
end


