function   [normal_stat , index_tbl] = ...
             vb_cortex_normal_statics(brainfile,areafile,areakey,Rmax)
% BV original brain neighbor for specified vertex
%  [normal_stat , index_tbl] = ...
%              vb_cortex_normal_statics(brainfile,areafile,areakey,Rmax)
% --- Input
% brainfile
% areafile
% areakey
% 
% Rmax    : max radius of neighbor search
%
% In the brainfile, 'normal_stat' should be exist:
%   normal_stat.neighbor_org : BV original brain neighbor for cortical vertex
%   normal_stat.normal_org   : BV original brain normal vector
% --- Output
% normal_stat.neighbor_org : BV original brain neighbor for specified vertex
% normal_stat.normal_org   : BV original brain normal vector
% 
% index_tbl.parent_ix   = vertex index in the brain model for specified vertex
% index_tbl.neighbor_ix = neighbor index in the brain model for specified vertex
%
% M. Sato  2006-7-14
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% Search neighbor points along cortex sheet 
% and calculate normal direction statistics
%

% Max radius of neighbor search
if ~exist('Rmax','var') | ~isempty(Rmax)
	Rmax = 0.004;	% 6mm
end


load(brainfile, 'n*')

if ~exist('normal_stat','var'), 
	error(['There is no normal_stat variable in ' brainfile]);
end

Area  = vb_get_area(areafile,areakey);
Vindx = Area.Iextract;

fprintf('--- Make member list of brain\n')
%tic
root_id = vb_find_near_root(Vindx,nextIX,nextDD,Rmax);
%vb_ptime(toc)

clear nextIX nextDD

index_tbl.parent_ix   = Vindx;
index_tbl.neighbor_ix = root_id;

%
% --- original vertex near the cortical vertex
%
% normal_stat.neighbor_org : original brain neighbor index list
% normal_stat.normal_org   : original brain normal vector

%
% --- Marge member list
%
fprintf('--- Marge member list \n')
merge_id = vb_merge_member_list( root_id, normal_stat.neighbor_org );

normal_stat.neighbor_org = merge_id;
