function    [cortexL, cortexR] = vb_cortex_area_index(Vinfo,Vindex,IndxL,IndxR)
% Find left/right cortex indices of brain model 'V' of VBMEG.
% [Input]
%    Vinfo.NdipoleL0 : The number of vertices of original left brain model.
%         .NdipoleR0 : The number of vertices of origianl right brain model.
%         .NdipoleL  : The number of vertices of VBMEG left brain.
%         .NdipoleR  : The number of vertices of VBMEG right brain.
%    Vindex.cortexL  : Indices representing Cortex in original left brain model.
%          .cortexR  : Indices representing Cortex in original right brain model.
%    IndxL           : Indices of original left brain model corresponding to 
%                      the left brain model of VBMEG.
%    IndxR           : Indices of original right brain model corresponding to 
%                      the right brain model of VBMEG.
% [Output]
%    cortexL : Indices of Cortex in brain model 'V' of VBMEG.
%    cortexR : Indices of Cortex in brain model 'V' of VBMEG.
%
% [Note]
%    The left and right brain models are managed separately.
%
% [History]
%    2017-03-15 M.Sato


% Cortex flag of original surface
flgL = zeros(Vinfo.NdipoleL0,1);
flgR = zeros(Vinfo.NdipoleR0,1);

% Set Cortex area
flgL(Vindex.cortexL) = 1;
flgR(Vindex.cortexR) = 1;

% Transform table from Original surface to Reduced surface
tblL = zeros(Vinfo.NdipoleL0,1);
tblR = zeros(Vinfo.NdipoleR0,1);

% Set selected reduced area
tblL(IndxL) = 1:Vinfo.NdipoleL;
tblR(IndxR) = 1:Vinfo.NdipoleR;

% Get cortex area in Reduced surface
ixL  = find( tblL .* flgL > 0);
ixR  = find( tblR .* flgR > 0);

% Cortex index in Reduced surface
cortexL = tblL(ixL);
cortexR = tblR(ixR) + Vinfo.NdipoleL;
