function	xxdev = vb_calc_normal_variance(member_id, xx)
% Deviation angle from average normal vector in the neighbor of root vertex
%   xxdev = vb_calc_normal_variance(member_id, xx)
% --- Input
% member_id{n} : member vertex index which belog to the n-th root point 
% xx(i,:)      : normal vector at the vertex-i in the original brain
% --- Output
% xxdev : deviation angle from average normal vector
%
% M. Sato  2006-7-14
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Number of target vertex for calculation
Nroot = length(member_id);		

% Deviation angle from average normal vector
xxdev = zeros(Nroot,1);

for n=1:Nroot,
	% neighbor point index
	inext = member_id{n};
	Nnext = length(inext);
	
	% normal vector of neighbor point
	xxnext = xx(inext,:);
	
	% mean normal vector
	xxn = sum(xxnext,1);
	xxs = max( sqrt(sum(xxn.^2)), eps );
	xxn = xxn/xxs;
	
	% mean angle from mean normal vector
	xxdev(n) = sum(acos(xxnext*xxn'))/Nnext;
end;
