function	xxave = vb_calc_normal_average(member_id, xx)
% average normal direction in the neighbor of root vertex
%   xxave = vb_calc_normal_average(member_id, xx)
% --- Input
% member_id{n} : member vertex index which belog to the n-th root point 
% xx(i,:)      : normal vector at the vertex-i in the original brain
% --- Output
% xxave(n,:) : average normal vector of n-th root point 
%              over its neighborhood of original brain
%
% M. Sato  2006-7-23
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Number of target vertex for calculation
Nroot = length(member_id);		

% average normal vector
xxave = zeros(Nroot,3);

for n=1:Nroot,
	% neighbor point index
	inext = member_id{n};
	
	% mean normal vector
	xxn = sum( xx(inext,:), 1);
	xxs = sum(xxn.^2);
	if xxs > 0
		xxave(n,:) = xxn/sqrt(xxs);
	end
end;
