function [ext_index,ext_table] = ...
               vb_asign_neighbor_vertex(base_index,nextIX,nextDD)
%  asign external vertex by base vertex according to distance
%  [ext_index,ext_table] = vb_asign_neighbor_vertex(base_index,nextIX,nextDD);
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nbase = length(base_index);
Nall  = size(nextDD,1);

base_flag = zeros(Nall,1);
base_flag(base_index) = 1;

ext_index = vb_setdiff2([1:Nall], base_index);
Next = length(ext_index);
ext_table = cell(Next,1);

for i=1:Next
    ix     = ext_index(i);
    
    % neighbor index of ext_index(i)
    inext  = nextIX{ix};
    % neighbor distance of ext_index(i)
    nextdd = nextDD{ix};
    
    % base_index in inext
    jnext  = find(base_flag(inext) > 0 );
    % distance to base_index vertex
    jdd = nextdd(jnext);
    [dmin,jj] = min(jdd);
    
    % base_index nearest to ext_index(i)
    jmin = jnext(jj);
    ext_table{i} = inext(jmin);
end
