function avw = Analyze_read_help(file,IMGorient)

% AVW_IMG_READ: read Analyze format data image (*.img)
% 
% avw = avw_img_read(fileprefix, orient)
% 
% file - a string, the filename without the .img extension
% 
% orient - read a specified orientation, integer values:
% 
%          '', use header history orient field
%          0,  transverse unflipped (LAS*)
%          1,  coronal unflipped (LA*S)
%          2,  sagittal unflipped (L*AS)
%          3,  transverse flipped (LPS*)
%          4,  coronal flipped (LA*I)
%          5,  sagittal flipped (L*AI)
% 
% where * follows the slice dimension and letters indicate +XYZ
% orientations (L left, R right, A anterior, P posterior,
% I inferior, & S superior).  The returned 3D matrix will 
% correspond with the default ANALYZE coordinate system, which 
% is Left-handed:
% 
% X-Y plane is Transverse
% X-Z plane is Coronal
% Y-Z plane is Sagittal
% 
% X axis runs from patient right (low X) to patient Left (high X)
% Y axis runs from posterior (low Y) to Anterior (high Y)
% Z axis runs from inferior (low Z) to Superior (high Z)
% 
% Some files may contain data in the 3-5 orientations, but this
% is unlikely. For more information about orientation, see the
% documentation at the end of this .m file.  See also the 
% AVW_FLIP function for orthogonal reorientation.
% 
% Returned values:
% 
% avw.hdr - a struct with image data parameters.
% avw.img - a 3D matrix of image data (double precision).
% 
% See also: AVW_HDR_READ (called by this function), 
%           AVW_VIEW, AVW_IMG_WRITE, AVW_FLIP
% 

